program install;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Program for Installing the IK 121                    }
{                                                       }
{ V 1.01                                                }
{ April 1995                                             }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,graph,logo,ik121_0,ik121_1,cnt_0;

var
  nr    : byte;
  eing  : char;
  adr   : word;
(*************************************)
function test(adr:word):boolean;
var
  i,muster,buffer : byte;
  free            : boolean;
begin

  free:=true;
  for i:=0 to $0F do
    begin
      buffer:=port[adr+i];
      if (buffer<>$FF) then free:=false;
    end;

  if free then
    begin
      muster:=$AA;
      for i:=0 to $0F do
        begin
          port[adr+i]:=muster;
          muster:=not(muster);
        end;
      for i:=0 to $0F do
        begin
          buffer:=port[adr+i];
          if (buffer<>$FF) then free:=false;
        end;
    end;
  test:=free;
end;
(*************************************)
procedure adrtest(nr,adr:word;xpos,ypos:byte);
var
  w : string4;
  t : word;
begin
  word_hex(adr,w);
  if test(adr) then
    begin
      gotoxy(xpos,ypos);
      write('Nr:',nr,' Adr.:',w[4],w[3],w[2],w[1],' free')
    end
  else
    begin
      t:=read_g26(adr,1,28);
      t:=t and $FF00;
      if t=$0800 then
        begin
          gotoxy(xpos,ypos);
          write('Nr:',nr,' Adr.:',w[4],w[3],w[2],w[1],' **IK121**');
        end
      else
        begin
          gotoxy(xpos,ypos);
          write('Nr:',nr,' Adr.:',w[4],w[3],w[2],w[1],' not free');
        end;
    end;
end;
(*************************************)
procedure base_address(var number:byte);
begin
  writeln;
  writeln(' Searching for free I/O space');
  writeln;
  adrtest(1,$300,2,10);
  adrtest(2,$310,2,11);
  adrtest(3,$320,2,12);
  adrtest(4,$330,2,13);
  adrtest(5,$340,2,14);
  adrtest(6,$350,2,15);
  adrtest(7,$390,2,16);
  adrtest(8,$210,2,17);
  adrtest(9,$220,2,18);
  adrtest(10,$230,2,19);
  adrtest(11,$240,2,20);
  adrtest(12,$250,2,21);
  adrtest(13,$260,2,22);
  adrtest(14,$280,2,23);
  adrtest(15,$290,30,10);
  adrtest(16,$2A0,30,11);
  adrtest(17,$2B0,30,12);
  adrtest(18,$2C0,30,13);
  adrtest(19,$2D0,30,14);
  adrtest(20,$110,30,15);
  adrtest(21,$120,30,16);
  adrtest(22,$130,30,17);
  adrtest(23,$140,30,18);
  adrtest(24,$150,30,19);
  adrtest(25,$160,30,20);
  adrtest(26,$170,30,21);
  adrtest(27,$180,30,22);
  adrtest(28,$190,30,23);
  adrtest(29,$1A0,60,10);
  adrtest(30,$1B0,60,11);
  adrtest(31,$1C0,60,12);
  adrtest(32,$1D0,60,13);
  adrtest(33,$1E0,60,14);
  adrtest(34,$0E0,60,15);
  gotoxy(5,5);
  write(' Enter Nr.? ');
  readln(number);
end;
(*************************************)
procedure show_address(number:word;var adr:word);
var
   w      : string4;
   i      : byte;
begin
  case number of
    1 : adr:=$300;
    2 : adr:=$310;
    3 : adr:=$320;
    4 : adr:=$330;
    5 : adr:=$340;
    6 : adr:=$350;
    7 : adr:=$390;
    8 : adr:=$210;
    9 : adr:=$220;
   10 : adr:=$230;
   11 : adr:=$240;
   12 : adr:=$250;
   13 : adr:=$260;
   14 : adr:=$280;
   15 : adr:=$290;
   16 : adr:=$2A0;
   17 : adr:=$2B0;
   18 : adr:=$2C0;
   19 : adr:=$2D0;
   20 : adr:=$110;
   21 : adr:=$120;
   22 : adr:=$130;
   23 : adr:=$140;
   24 : adr:=$150;
   25 : adr:=$160;
   26 : adr:=$170;
   27 : adr:=$180;
   28 : adr:=$190;
   29 : adr:=$1A0;
   30 : adr:=$1B0;
   31 : adr:=$1C0;
   32 : adr:=$1D0;
   33 : adr:=$1E0;
   34 : adr:=$0E0;
  end;
  clrscr;
  word_hex(adr,w);
  writeln;
  writeln(' Chosen address:'(*,w[4],w[3],w[2],w[1],'h'*));
  adrtest(number,adr,5,5);
  gotoxy(1,10);
  writeln(' The DIP switch position on your interface card is:');
  writeln;

  if (adr and $0010)=$0010 then
    begin
      gotoxy(1,12);
      writeln('    A4--off');
      gotoxy(30,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,12);
      writeln('    A4--on');
      gotoxy(30,20);
      write(#178);
    end;
  if (adr and $0020)=$0020 then
    begin
      gotoxy(1,13);
      writeln('    A5--off');
      gotoxy(32,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,13);
      writeln('    A5--on');
      gotoxy(32,20);
      write(#178);
    end;
  if (adr and $0040)=$0040 then
    begin
      gotoxy(1,14);
      writeln('    A6--off');
      gotoxy(34,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,14);
      writeln('    A6--on');
      gotoxy(34,20);
      write(#178);
    end;
  if (adr and $0080)=$0080 then
    begin
      gotoxy(1,15);
      writeln('    A7--off');
      gotoxy(36,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,15);
      writeln('    A7--on');
      gotoxy(36,20);
      write(#178);
    end;
  if (adr and $0100)=$0100 then
    begin
      gotoxy(1,16);
      writeln('    A8--off');
      gotoxy(38,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,16);
      writeln('    A8--on');
      gotoxy(38,20);
      write(#178);
    end;
 if (adr and $0200)=$0200 then
    begin
      gotoxy(1,17);
      writeln('    A9--off');
      gotoxy(40,21);
      write(#178);
    end
  else
    begin
      gotoxy(1,17);
      writeln('    A9--on');
      gotoxy(40,20);
      write(#178);
    end;

  for i:=28 to 42 do
    begin
      gotoxy(i,19);
      write(#196);
    end;
  for i:=28 to 42 do
    begin
      gotoxy(i,22);
      write(#196);
    end;
  gotoxy(28,19);
  write(#218);
  gotoxy(28,22);
  write(#192);
  gotoxy(42,19);
  write(#191);
  gotoxy(42,22);
  write(#217);
  gotoxy(28,20);
  write(#179);
  gotoxy(28,21);
  write(#179);
  gotoxy(42,20);
  write(#179);
  gotoxy(42,21);
  write(#179);
  gotoxy(28,18);
  write('on');
  gotoxy(28,23);
  write('A4');
  gotoxy(40,23);
  write('A9');
  gotoxy(50,24);
  write('Press Return');
  readln;
end;
(*************************************)
procedure saveadr(adr:word);
begin
  write_adr(adr);
  clrscr;
  gotoxy(1,5);
  writeln(' Chosen address stored in IK121.INI');
  writeln;
  writeln(' Ensure right DIP switch positions!');
  writeln(' Turn power off!');
  writeln(' Put in your interface card');
  writeln(' Run IK121.EXE');
  writeln;
  write(' Press Return');
  readln;
end;
(*************************************)
begin
  jh_logo;
  sound(400);
  delay(500);
  sound(500);
  delay(500);
  sound(600);
  delay(500);
  nosound;
  delay(500);
  closegraph;
  textbackground(7);
  clrscr;
  gotoxy(1,5);
  textcolor(15);
  writeln('  INSTALL IK 121 ');
  writeln;
  writeln('  The IK 121 Interface Card should not be in your PC!');
  writeln;
  write('  Continue (y/n)?');
  repeat
  until keypressed;
  eing:=readkey;
  if (eing='y') or (eing='Y') then
    begin
      clrscr;
      base_address(nr);
      show_address(nr,adr);
      saveadr(adr);
    end;
  textbackground(0);
  clrscr;
end.